<?php
/**
 * Anowave Magento 2 Mass Actions
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Massactions
 * @copyright 	Copyright (c) 2017 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */
namespace Anowave\Massactions\Controller\Adminhtml\Massactions;
 
use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;

class MassDelete extends \Magento\Backend\App\Action
{
	/**
	 * @var \Anowave\Massactions\Helper\Data
	 */
	protected $helper = null;
	
	/**
	 * Constructor 
	 * 
	 * @param \Magento\Backend\App\Action\Context $context
	 * @param \Anowave\Massactions\Helper\Data $helper
	 */
	public function __construct
	(
		\Magento\Backend\App\Action\Context $context,
		\Anowave\Massactions\Helper\Data $helper
	)
	{
		parent::__construct($context);
		
		$this->helper = $helper;
	}
	
    public function execute()
    {
    	$log = [];
    	
    	if ($_POST && $this->helper->isActive())
    	{
    		if ('' !== $this->getRequest()->getParam('id'))
    		{
    			foreach ($this->helper->filter((array) $this->getRequest()->getParam('id')) as $id)
    			{
    				if ((int) $id) 
    				{
    					try 
    					{
    						$model = $this->_objectManager->create('Magento\SalesRule\Model\Rule');
    						
    						$model->load((int) $id);
    						$model->delete();
    						
    						$log[] = true;
    						
    					} 
    					catch (\Magento\Framework\Exception\LocalizedException $e) 
    					{
    						$this->messageManager->addError($e->getMessage());
    					} 
    					catch (\Exception $e) 
    					{
    						$this->messageManager->addError
    						(
    							__('We can\'t delete the rule right now. Please review the log and try again.')
    						);
    					}
    				}
    			}
    			
    			if ($log)
    			{
    				$this->messageManager->addSuccess(__('You deleted ' . count($log) .' rule(s) successfully.'));
    			}
    		}
    	}
    	
    	if (!$log)
    	{
    		$this->messageManager->addWarning(__('No rules were deleted.'));
    	}
    	
    	/**
    	 * Return back
    	 */
    	$this->_redirect('sales_rule/promo_quote/index');
    }
}