<?php
/**
 * Anowave Magento 2 Mass Actions
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Anowave license that is
 * available through the world-wide-web at this URL:
 * http://www.anowave.com/license-agreement/
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade this extension to newer
 * version in the future.
 *
 * @category 	Anowave
 * @package 	Anowave_Massactions
 * @copyright 	Copyright (c) 2017 Anowave (http://www.anowave.com/)
 * @license  	http://www.anowave.com/license-agreement/
 */

namespace Anowave\Massactions\Helper;

use Magento\Store\Model\Store;
use Anowave\Package\Helper\Package;
use Magento\Framework\Registry;
use Anowave\Package\Helper\Base;

class Data extends \Anowave\Package\Helper\Package
{
	/**
	 * Package name
	 * @var string
	 */
	protected $package = 'MAGE2-MASSACTIONS';
	
	/**
	 * Config path 
	 * @var string
	 */
	protected $config = 'massactions/general/license';
	
	/**
	 * Check if module is active
	 *
	 * @return boolean
	 */
	public function isActive()
	{
		return 0 !== (int) $this->getConfig('massactions/general/active');
	}

	public function getCurrentStore()
	{
		return \Magento\Framework\App\ObjectManager::getInstance()->get('\Magento\Store\Model\StoreManagerInterface')->getStore();
	}
}