# Upgrade Compatibility Tool

Welcome to the Adobe Commerce Upgrade Compatibility Tool.

The Upgrade Compatibility Tool is a command-line tool that checks an Adobe Commerce customized instance against a specific version by analyzing all modules and core code installed in it. It returns a list of critical issues, errors, and warnings that must be addressed before upgrading to the latest version of Adobe Commerce. It also identifies potential problems that must be fixed in your code before attempting to upgrade to a newer version of Adobe Commerce.

The Upgrade Compatibility Tool allows you to identify when core code changes have been made to customized features.

It is distributed as a Composer package with every release of an Adobe Commerce version.

Refer to the [Upgrade Compatibility Tool devdocs](https://experienceleague.adobe.com/docs/commerce-operations/upgrade-guide/upgrade-compatibility-tool/overview.html?lang=en) page for the first steps with the Upgrade Compatibility Tool.

## Upgrade Compatibility Tool developer guide

[Upgrade Compatibility Tool developer guide](https://github.com/magento-commerce/uct/blob/develop/docs/README.md) contains all information needed to build and publish an offical UCT package in `repo.magento.com`.

## Upgrade Compatibility Tool Tracking

[Upgrade Compatibility Tool Tracking](https://github.com/magento-commerce/safe-upgrade-tool-tracking) is a small AWS Lambda created with [Go](https://go.dev/). This lambda receives metrics from UCT and send it to CloudWatch.

## Help improve the Upgrade Compatibility Tool

We want to hear your feedback, issues and suggestions to help us improve the tool. To connect with the Upgrade Compatibility Tool team contact us on the Engineering Slack channel [Upgrade Compatibility Tool](https://magentocommeng.slack.com/archives/C019Y143U9F).

To become one of our official contributors - learn about our [Best Practices](https://developer.adobe.com/commerce/contributor/community/best-practices/) and visit [Contribution programs](https://developer.adobe.com/commerce/contributor/community/contribution-programs/) for more details.

See the [Resources](https://devdocs.magento.com/community/resources.html) page for more information about providing feedback to our engineers.

