<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\Cmd;

class CommandExecution
{
    /**
     * @var string
     */
    private $result;

    /**
     * @var array
     */
    private $output;

    /**
     * @var string
     */
    private $exitCode;

    /**
     * CommandExecution constructor.
     * @param string $result
     * @param array $output
     * @param int $exitCode
     */
    public function __construct(string $result, array $output, int $exitCode)
    {
        $this->result = $result;
        $this->output = $output;
        $this->exitCode = $exitCode;
    }

    /**
     * @return string
     */
    public function getResult(): string
    {
        return $this->result;
    }

    /**
     * @return array
     */
    public function getOutput(): array
    {
        return $this->output;
    }

    /**
     * @return int
     */
    public function getExitCode(): int
    {
        return $this->exitCode;
    }
}
