<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Compatibility\Analyzers;

use Sut\Domain\Issue\DTO\Issue;
use Sut\Domain\MRay\DTO\Module;

interface AnalyzerInterface
{
    /**
     * @param Module\Dependency $dependency
     * @param Module\DependencyUsage $usage
     * @param string $version
     * @return Issue[]
     */
    public function analyze(Module\Dependency $dependency, Module\DependencyUsage $usage, string $version): array;
}
