<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Compatibility\Data;

use Exception;
use Sut\Domain\Time\TimerInterface;
use Symfony\Component\Console\Input\InputInterface;

class AnalysisRequestFactory
{
    /**
     * @var TimerInterface
     */
    private $timer;

    /**
     * @param TimerInterface $timer
     */
    public function __construct(TimerInterface $timer)
    {
        $this->timer = $timer;
    }

    /**
     * @param InputInterface $input
     * @param string $analysisPath
     * @param string $currentVersion
     * @param string $comingVersion
     * @param int $minLevel
     * @return AnalysisRequest
     * @throws Exception
     */
    public function create(
        InputInterface $input,
        string $analysisPath,
        string $currentVersion,
        string $comingVersion,
        int $minLevel
    ): AnalysisRequest {
        return new AnalysisRequest(
            $analysisPath,
            $currentVersion,
            $comingVersion,
            $input->getOption('context'),
            $minLevel,
            $input->getOption('json-output-path'),
            $input->getOption('html-output-path'),
            $this->timer
        );
    }
}
