<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Compatibility\Data;

use Exception;
use Sut\Domain\Compatibility\GetMemoryPeakUsage;
use Sut\Domain\Time\TimerInterface;

class AnalysisResultFactory
{
    /**
     * @var TimerInterface
     */
    private $timer;

    /**
     * @var GetMemoryPeakUsage
     */
    private $getMemoryPeakUsage;

    /**
     * @param TimerInterface $timer
     * @param GetMemoryPeakUsage $getMemoryPeakUsage
     */
    public function __construct(TimerInterface $timer, GetMemoryPeakUsage $getMemoryPeakUsage)
    {
        $this->timer = $timer;
        $this->getMemoryPeakUsage = $getMemoryPeakUsage;
    }

    /**
     * @param array $modules
     * @param AnalysisRequest $analysisRequest
     * @return AnalysisResult
     * @throws Exception
     */
    public function create(
        array $modules,
        AnalysisRequest $analysisRequest
    ): AnalysisResult {
        return new AnalysisResult($modules, $analysisRequest, $this->timer, $this->getMemoryPeakUsage);
    }
}
