<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Compatibility;

use Exception;
use Sut\Domain\Compatibility\Data\AnalysisResult;
use Symfony\Component\Console\Style\SymfonyStyle;

class Output implements OutputInterface
{
    /**
     * @var OutputInterface[]
     */
    private $outputs;

    /**
     * @param OutputInterface[] $outputs
     */
    public function __construct(array $outputs)
    {
        $this->outputs = $outputs;
    }

    /**
     * @param SymfonyStyle $output
     * @param AnalysisResult $analysisResult
     */
    public function write(
        SymfonyStyle $output,
        AnalysisResult $analysisResult
    ): void {
        foreach ($this->outputs as $outputService) {
            if (!$outputService instanceof OutputInterface) {
                $output->getErrorStyle()->writeln(
                    sprintf('<error>%s should implement OutputInterface</error>', get_class($outputService))
                );
            }
            try {
                $outputService->write($output, $analysisResult);
            } catch (Exception $exception) {
                $output->getErrorStyle()->writeln('<error>' . $exception->getMessage() . '</error>');
            }
        }
    }
}
