<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Compatibility\Output;

use Exception;
use RuntimeException;

class SaveFile
{
    private const MASK = 0777;
    private const RECURSIVE = true;

    /**
     * @param string $path
     * @param string $content
     * @throws Exception
     */
    public function execute(string $path, string $content): void
    {
        // phpcs:ignore
        $path =  str_replace("~", $_SERVER['HOME'], $path);
        $directory = pathinfo($path, PATHINFO_DIRNAME);

        if (!is_dir($directory)) {
            if (!mkdir($directory, SaveFile::MASK, SaveFile::RECURSIVE)) {
                throw new RuntimeException(sprintf("Can not save content to '%s'", $path));
            }
        }
        file_put_contents($path, $content);
    }
}
