<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Compatibility\Output;

use Sut\Domain\Compatibility\Data\AnalysisResult;
use Sut\Domain\Compatibility\OutputInterface;
use Sut\Domain\Tracking\Track\UpdateCheckData;
use Sut\Domain\Tracking\Tracker;
use Symfony\Component\Console\Style\SymfonyStyle;

class Tracking implements OutputInterface
{
    /**
     * @var Tracker
     */
    private $tracker;

    /**
     * @param Tracker $tracker
     */
    public function __construct(Tracker $tracker)
    {
        $this->tracker = $tracker;
    }

    /**
     * @param SymfonyStyle $output
     * @param AnalysisResult $analysisResult
     */
    public function write(
        SymfonyStyle $output,
        AnalysisResult $analysisResult
    ): void {
        $this->tracker->sendData(
            new UpdateCheckData(
                $this->getExecutionTime($analysisResult),
                $analysisResult->getAnalysisRequest()->getCurrentVersion(),
                $analysisResult->getAnalysisRequest()->getComingVersion(),
                $analysisResult->getMemoryPeakUsage(),
                count($analysisResult->getSummary()->getErrors()),
                count($analysisResult->getSummary()->getWarnings()),
                count($analysisResult->getSummary()->getCriticals()),
                true,
                $analysisResult->getAnalysisRequest()->getContext()
            )
        );
    }

    /**
     * @param AnalysisResult $analysisResult
     * @return int
     */
    private function getExecutionTime(AnalysisResult $analysisResult): int
    {
        $interval = $analysisResult->getCreationTime()
            ->diff($analysisResult->getAnalysisRequest()->getCreationTime());

        return $interval->s + $interval->m * 60 + $interval->h * 3600;
    }
}
