<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\Eslint;

use Sut\Domain\Issue\DTO\Issue;
use Sut\Domain\Issue\Converter\GetFromEslintJson as IssueConverter;
use Sut\Infrastructure\Cmd\CmdService;

class GetEslintIssues
{
    private const CONFIG_PATH = "/vendor/magento/magento-coding-standard/eslint/.eslintrc";
    private const RULESDIR_PATH = "/vendor/magento/magento-coding-standard/eslint/rules";
    private const ESLINT_CMD =
        "/node_modules/.bin/eslint --no-error-on-unmatched-pattern --no-eslintrc --format json " .
        "-c %s --rulesdir %s --ignore-pattern %s -- %s";

    /**
     * @var CmdService
     */
    private $cmdService;

    /**
     * @var IssueConverter
     */
    private $issueConverter;

    /**
     * @var string
     */
    private $projectRoot;

    /**
     * @param CmdService $cmdService
     * @param IssueConverter $issueConverter
     * @param string $projectRoot
     */
    public function __construct(CmdService $cmdService, IssueConverter $issueConverter, string $projectRoot)
    {
        $this->cmdService = $cmdService;
        $this->issueConverter = $issueConverter;
        $this->projectRoot = $projectRoot;
    }

    /**
     * @param string $pathToAnalyze
     * @param string $ignorePattern
     * @return Issue[]
     */
    public function execute(string $pathToAnalyze, string $ignorePattern = "*vendor*") : array
    {
        $eslintJson = $this->cmdService->execCommand(
            sprintf(
                $this->projectRoot . self::ESLINT_CMD,
                $this->projectRoot . self::CONFIG_PATH,
                $this->projectRoot . self::RULESDIR_PATH,
                $ignorePattern,
                $pathToAnalyze
            )
        );

        if (!isset($eslintJson->getOutput()[0]) || !$eslintJson->getOutput()[0]) {
            return [];
        }

        return $this->issueConverter->execute($eslintJson->getOutput()[0]);
    }
}
