<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Etalon\DTO;

use Sut\Domain\Issue\DTO\Issue;

class ModificationCheckResult
{
    /**
     * @var Issue[]
     */
    private $issues;

    /**
     * @var int
     */
    private $totalCheckedFiles;

    /**
     * @var int
     */
    private $totalFilesModified;

    /**
     * @param Issue[] $issues
     * @param int $totalCheckedFiles
     * @param int $totalFilesModified
     */
    public function __construct(array $issues, int $totalCheckedFiles, int $totalFilesModified)
    {
        $this->issues = $issues;
        $this->totalCheckedFiles = $totalCheckedFiles;
        $this->totalFilesModified = $totalFilesModified;
    }

    /**
     * @return int
     */
    public function getTotalCheckedFiles(): int
    {
        return $this->totalCheckedFiles;
    }

    /**
     * @return int
     */
    public function getTotalFilesModified(): int
    {
        return $this->totalFilesModified;
    }

    /**
     * @return Issue[]
     */
    public function getIssues(): array
    {
        return $this->issues;
    }
}
