<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\FileSystem;

use RuntimeException;

interface FileSystemInterface
{
    /**
     * @param string $path
     * @param bool $force
     * @throws RuntimeException
     */
    public function createDirectory(string $path, bool $force = true): void;

    /**
     * @param string $filePath
     * @return mixed
     */
    public function openFile(string $filePath);
}
