<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\Issue\Converter;

use InvalidArgumentException;
use Sut\Domain\Issue\DTO\Issue;
use Sut\Domain\Issue\IssueFactory;

class GetFromEslintJson
{
    /**
     * @var IssueFactory
     */
    private $issueFactory;

    /**
     * @param IssueFactory $issueFactory
     */
    public function __construct(IssueFactory $issueFactory)
    {
        $this->issueFactory = $issueFactory;
    }

    /**
     * @param string $eslintJson
     * @return Issue[]
     */
    public function execute(string $eslintJson): array
    {
        $issues = [];
        $eslintArray = json_decode($eslintJson, true);
        if (empty($eslintArray)) {
            return [];
        }

        foreach ($eslintArray as $eslintIssue) {
            if (!isset($eslintIssue['filePath']) || !isset($eslintIssue['messages'])) {
                continue;
            }
            $file = $eslintIssue['filePath'];
            foreach ($eslintIssue['messages'] as $message) {
                if (!isset($message['ruleId']) || !isset($message['message']) || !isset($message['line'])) {
                    continue;
                }
                try {
                    $issues[] = $this->issueFactory->createIssueByType(
                        $message['ruleId'],
                        $message['message'],
                        $message['line'],
                        $file
                    );
                // phpcs:ignore Magento2.CodeAnalysis.EmptyBlock.DetectedCatch
                } catch (InvalidArgumentException $exception) {
                    // error types that are not present in the configuration are ignored
                }
            }
        }

        return $issues;
    }
}
