<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\Issue\Converter;

use InvalidArgumentException;
use Sut\Domain\Issue\DTO\Issue;
use Sut\Domain\Issue\IssueFactory;

class GetFromPhpCsJson
{
    /**
     * @var IssueFactory
     */
    private $issueFactory;

    /**
     * @param IssueFactory $issueFactory
     */
    public function __construct(IssueFactory $issueFactory)
    {
        $this->issueFactory = $issueFactory;
    }

    /**
     * @param string $phpCsJson
     * @return Issue[]
     */
    public function execute(string $phpCsJson): array
    {
        $issues = [];
        $phpCsArray = json_decode($phpCsJson, true);

        if (!isset($phpCsArray['files']) || empty($phpCsArray['files'])) {
            return [];
        }

        foreach ($phpCsArray['files'] as $fileName => $file) {
            foreach ($file['messages'] as $message) {
                try {
                    if (!isset($message['source']) || !isset($message['message']) || !isset($message['line'])) {
                        continue;
                    }
                    $issues[] = $this->issueFactory->createIssueByType(
                        $message['source'],
                        $message['message'],
                        $message['line'],
                        $fileName,
                    );
                // phpcs:ignore Magento2.CodeAnalysis.EmptyBlock.DetectedCatch
                } catch (InvalidArgumentException $exception) {
                    // error types that are not present in the configuration are ignored
                }
            }
        }

        return $issues;
    }
}
