<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */

namespace Sut\Domain\Issue;

use Sut\Domain\Issue\DTO\Issue;

class IssueNormalizer
{
    /**
     * @param array $issues
     * @return Issue[]
     */
    public function normalizeIssues(array $issues): array
    {
        $normalizedIssues = [];
        $modules = $issues;
        foreach ($modules as $module) {
            foreach ($module as $fileIssues) {
                /** @var Issue $fileIssue */
                foreach ($fileIssues as $fileIssue) {
                    $normalizedIssues[$fileIssue->getUniqueId()] = $fileIssue;
                }
            }
        }
        return $normalizedIssues;
    }
}
