<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */

namespace Sut\Domain\Issue;

use Sut\Domain\Issue\DTO\Issue;

class IssueSerializer
{
    /**
     * @param Issue[] $issues
     * @return Issue[]
     */
    public function serializeIssues(array $issues): array
    {
        foreach ($issues as $key => $issue) {
            $issues[$key] = $this->serializeIssue($issue);
        }
        return $issues;
    }

    /**
     * @param Issue $issue
     * @return array
     */
    public function serializeIssue(Issue $issue): array
    {
        $serializedIssue = [
            'lineNumber' => $issue->getLineNumber(),
            'issueType' => $issue->getIssueType(),
            'level' => $issue->getLevelString(),
            'message' => $issue->getMessage(),
            'code' => $issue->getCode(),
            'fileName' => $issue->getFileName(),
            'validationType' => $issue->getValidationType(),
        ];
        if ($issue->getLineNumber() === 0) {
            unset($serializedIssue['lineNumber']);
        }
        if (empty($issue->getIssueType())) {
            unset($serializedIssue['issueType']);
        }
        if (empty($issue->getFileName())) {
            unset($serializedIssue['fileName']);
        }
        return $serializedIssue;
    }
}
