<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\MRay\DTO;

use Sut\Domain\MRay\DTO\Module\Parameter;

class MethodSignature
{
    /**
     * @var Parameter[]
     */
    private $parameters;

    /**
     * @var string
     */
    private $returnType;

    /**
     * @param Parameter[] $parameters
     * @param string $returnType
     */
    public function __construct(array $parameters, string $returnType)
    {
        $this->parameters = $parameters;
        $this->returnType = $returnType;
    }

    /**
     * @return Parameter[]
     */
    public function getParameters(): array
    {
        return $this->parameters;
    }

    /**
     * @return string
     */
    public function getReturnType(): string
    {
        return $this->returnType;
    }
}
