<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\MRay\DTO;

use Sut\Domain\MRay\DTO\Module\Dependency;

/**
 * Class Module is a DTO which holds information related to a module, such as:
 * - Its name
 * - To which package does it belong
 * - Its version number
 * - Which dependencies does it have
 */
class Module
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $package;

    /**
     * @var string
     */
    private $version;

    /**
     * @var Dependency[]
     */
    private $dependencies;

    /**
     * @var string
     */
    private $path;

    /**
     * @param string $name
     * @param string $package
     * @param string $version
     * @param array $dependencies
     * @param string $path
     */
    public function __construct(
        string $name,
        string $package,
        string $version,
        array $dependencies = [],
        string $path = ''
    ) {
        $this->name = $name;
        $this->package = $package;
        $this->version = $version;
        $this->dependencies = $dependencies;
        $this->path = $path;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getPackage(): string
    {
        return $this->package;
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @return Dependency[]
     */
    public function getDependencies(): array
    {
        return $this->dependencies;
    }

    /**
     * @return string
     */
    public function getPath(): string
    {
        return $this->path;
    }
}
