<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\MRay\DTO\Module;

use Sut\Domain\MRay\DTO\MethodSignature;
use Sut\Domain\MRay\DTO\Module;

class DependencyUsage
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $class;

    /**
     * @var int
     */
    private $position;

    /**
     * @var string
     */
    private $file;

    /**
     * @var MethodSignature
     */
    private $methodSignature;

    /**
     * @var array
     */
    private $data;

    /**
     * @param string $type
     * @param array $usage
     */
    public function __construct(string $type, array $usage)
    {
        $this->type = $type;
        $this->class = $usage['class'] ?? "";
        $this->position = $this->getStartLine($usage);
        $this->file = $usage['location']['file'] ?? "";
        $this->methodSignature = new MethodSignature(
            $this->getParameters($usage['arguments'] ?? []),
            $usage['returnType'] ?? ''
        );
        $this->data = $usage;
    }

    /**
     * @param array $usageParameters
     * @return array
     */
    private function getParameters(array $usageParameters): array
    {
        $processedUsageParameters = [];

        foreach ($usageParameters as $usageParameter) {
            $processedUsageParameters[] = new Module\Parameter(
                $usageParameter['type'],
                (int)($usageParameter['position'] ?? 0),
                $usageParameter['name'] ?? '',
                $usageParameter['optional'] ?? false
            );
        }

        return $processedUsageParameters;
    }

    /**
     * @param array $usage
     * @return int
     */
    private function getStartLine(array $usage): int
    {
        return $usage['location']['startLine'] ?? $usage['location']['position']['startLine'] ?? -1;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getClass(): string
    {
        return $this->class;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @return string
     */
    public function getFile(): string
    {
        return $this->file;
    }

    /**
     * @return MethodSignature
     */
    public function getMethodSignature(): MethodSignature
    {
        return $this->methodSignature;
    }

    /**
     * @return array
     */
    public function getData(): array
    {
        return $this->data;
    }
}
