<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\MRay\DTO\Module;

class Parameter
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var int
     */
    private $position;

    /**
     * @var string
     */
    private $name;

    /**
     * @var bool
     */
    private $optional;

    /**
     * @param string $type
     * @param int $position
     * @param string $name
     * @param bool $optional
     */
    public function __construct(string $type, int $position, string $name = '', bool $optional = false)
    {
        $this->type = $type;
        $this->position = $position;
        $this->name = $name;
        $this->optional = $optional;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return bool
     */
    public function isOptional(): bool
    {
        return $this->optional;
    }
}
