<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\Magento\DTO;

class MagentoEdition
{
    /***
     * @var string
     */
    private $edition;

    /**
     * @var string
     */
    private $editionName;

    private const COMPOSER_EDITION_NAMES = [
        'CE' => 'magento/project-community-edition',
        'EE' => 'magento/project-enterprise-edition'
    ];

    /**
     * @return string
     */
    public function getComposerEditionName(): string
    {
        return self::COMPOSER_EDITION_NAMES[$this->edition];
    }

    /**
     * @param string $edition
     * @param string $editionName
     */
    public function __construct(string $edition, string $editionName)
    {
        $this->edition = $edition;
        $this->editionName = $editionName;
    }

    /**
     * @return string
     */
    public function getEdition(): string
    {
        return $this->edition;
    }

    /**
     * @return string
     */
    public function getEditionName(): string
    {
        return $this->editionName;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return $this->edition;
    }
}
