<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Magento\DTO;

class MagentoInfo
{
    /**
     * @var string
     */
    private $version;

    /**
     * @var MagentoEdition
     */
    private $edition;

    /**
     * @param string $version
     * @param MagentoEdition|null $edition
     */
    public function __construct(string $version, MagentoEdition $edition = null)
    {
        $this->version = $version;
        $this->edition = $edition;
    }

    /**
     * @return string
     */
    public function getVersion(): string
    {
        return $this->version;
    }

    /**
     * @return MagentoEdition|null
     */
    public function getEdition(): ?MagentoEdition
    {
        return $this->edition;
    }

    /**
     * @return string
     */
    public function __toString(): string
    {
        return sprintf("%s%s", $this->version, $this->edition);
    }
}
