<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\OutputFormat\Console;

use Sut\Domain\Issue\DTO\Issue;
use Sut\Domain\Statistics\Statistics;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * Interface OutputFormat defines the contract required to output the SUT results in any kind of format.
 */
interface OutputFormatInterface
{
    /**
     * @param SymfonyStyle $output
     * @param Issue[] $issues
     */
    public function format(SymfonyStyle $output, array $issues): void;

    /**
     * @param SymfonyStyle $output
     * @param Statistics $stats
     */
    public function showStatistics(SymfonyStyle $output, Statistics $stats) : void;
}
