<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\OutputFormat\Console;

use Symfony\Component\Console\Formatter\OutputFormatterStyle;
use Symfony\Component\Console\Style\SymfonyStyle;

class OutputFormatService
{
    /**
     * @param SymfonyStyle $output
     */
    public function addStyles(SymfonyStyle $output): void
    {
        $output->getFormatter()->setStyle('critical', new OutputFormatterStyle('red', null));
        $output->getFormatter()->setStyle('warning', new OutputFormatterStyle('yellow', null));
        $output->getFormatter()->setStyle('file', new OutputFormatterStyle('black', null));
    }
}
