<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\OutputFormat\File;

use JsonException;
use Sut\Domain\Issue\DTO\Issue;
use Sut\Domain\Statistics\Statistics;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Interface OutputFormat defines the contract required to export the SUT results in any kind of format.
 */
interface OutputFormatInterface
{
    /**
     * @param OutputInterface $output
     * @param Issue[] $issues
     * @param Statistics $stats
     * @throws JsonException
     */
    public function export(OutputInterface $output, array $issues, Statistics $stats): void;
}
