<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\OutputFormat\File\Types;

use Sut\Domain\Issue\IssueSerializer;
use Sut\Domain\OutputFormat\File\OutputFormatInterface;
use Sut\Domain\Statistics\Statistics;
use Symfony\Component\Console\Output\OutputInterface;

class GraphQL implements OutputFormatInterface
{
    /**
     * @var IssueSerializer
     */
    private $issueSerializer;

    /**
     * @param IssueSerializer $issueSerializer
     */
    public function __construct(IssueSerializer $issueSerializer)
    {
        $this->issueSerializer = $issueSerializer;
    }

    /**
     * @inheritDoc
     */
    public function export(OutputInterface $output, array $issues, Statistics $stats): void
    {
        $export = [
            'issues' => $this->issueSerializer->serializeIssues($issues),
            'stats' => [
                'totalCriticals' => $stats->getNumberOfCriticals('graphql') ?? 0,
                'totalWarnings' => $stats->getNumberOfWarnings('graphql') ?? 0,
            ]
        ];
        $output->write(json_encode($export, JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT), true);
    }
}
