<?php
/**
 * Copyright 2021 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Domain\PhpCbf;

use Sut\Infrastructure\Cmd\CmdService;

class RefactorIssues
{
    private const PHPCBF_CMD = '/vendor/bin/phpcbf %s --standard=Magento2';

    /**
     * @var CmdService
     */
    private $cmdService;

    /**
     * @var string
     */
    private $projectRoot;

    /**
     * @param CmdService $cmdService
     * @param string $projectRoot
     */
    public function __construct(CmdService $cmdService, string $projectRoot)
    {
        $this->cmdService = $cmdService;
        $this->projectRoot = $projectRoot;
    }

    /**
     * @param string $path
     * @return array
     */
    public function execute(string $path) : array
    {
        $refactorOutput = $this->cmdService->execCommand(
            sprintf(
                $this->projectRoot . self::PHPCBF_CMD,
                $path
            )
        );

        return $refactorOutput->getOutput();
    }
}
