<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Domain\Tracking\Track;

use Sut\Domain\Tracking\Data\TrackInterface;

class CoreCodeChangesData implements TrackInterface
{
    /**
     * @var string
     */
    private $command;

    /**
     * @var int
     */
    private $executionTime;

    /**
     * @var int
     */
    private $numberOfChangedFiles;

    /**
     * @var float
     */
    private $percentageOfChangedFiles;

    /**
     * @var bool
     */
    private $success;

    /**
     * @var float
     */
    private $memoryPeakUsage;

    /**
     * @param string $command
     * @param int $executionTime
     * @param int $numberOfChangedFiles
     * @param float $percentageOfChangedFiles
     * @param float $memoryPeakUsage
     * @param bool $success
     */
    public function __construct(
        string $command,
        int $executionTime,
        int $numberOfChangedFiles,
        float $percentageOfChangedFiles,
        float $memoryPeakUsage,
        bool $success = true
    ) {
        $this->command = $command;
        $this->executionTime = $executionTime;
        $this->numberOfChangedFiles = $numberOfChangedFiles;
        $this->percentageOfChangedFiles = $percentageOfChangedFiles;
        $this->memoryPeakUsage = $memoryPeakUsage;
        $this->success = $success;
    }

    /**
     * @return string
     */
    public function serialize(): string
    {
        return sprintf(
            '
            {
                "Command" : "%s",
                "ExecutionTime" : %d,
                "NumberOfFilesChanged" : %d,
                "PercentageOfFilesChanged" : %f,
                "MemoryPeakUsage": %f,
                "Success" : %s
            }
            ',
            $this->command,
            $this->executionTime,
            $this->numberOfChangedFiles,
            $this->percentageOfChangedFiles,
            $this->memoryPeakUsage,
            $this->success ? "true" : "false"
        );
    }
}
