<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Infrastructure\Cmd;

use Sut\Domain\Cmd\CmdServiceInterface;
use Sut\Domain\Cmd\CommandExecution;

class CmdService implements CmdServiceInterface
{
    /**
     * @param string $command
     * @return CommandExecution
     */
    public function execCommand(string $command): CommandExecution
    {
        //phpcs:ignore Magento2.Security.InsecureFunction
        $result = exec($command, $output, $exitCode);

        return new CommandExecution($result, $output, $exitCode);
    }
}
