<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Infrastructure\Etalon;

use Sut\Domain\Etalon\HashFileInterface;

class MD5File implements HashFileInterface
{
    /**
     * Returns MD5 signature of file in passed path
     *
     * @param string $path
     * @return string
     */
    public function execute(string $path) : string
    {
        return md5_file($path);
    }
}
