<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
namespace Sut\Infrastructure\FileSystem;

use RuntimeException;
use Sut\Domain\FileSystem\FileSystemInterface;

class FileSystem implements FileSystemInterface
{
    /**
     * @param string $path
     * @param bool $force
     * @throws RuntimeException
     */
    public function createDirectory(string $path, bool $force = true): void
    {
        $pathInfo = pathinfo($path);
        if (is_dir($pathInfo['dirname'])) {
            return;
        }
        if (!mkdir(
            $concurrentDirectory = $pathInfo['dirname'],
            0777,
            $force
        ) && !is_dir($concurrentDirectory)) {
            throw new RuntimeException(sprintf('Directory "%s" was not created', $concurrentDirectory));
        }
    }

    /**
     * @param string $filePath
     * @param string $mode
     * @return false|resource
     */
    public function openFile(string $filePath, string $mode = 'wb')
    {
        return fopen($filePath, $mode);
    }
}
