<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Sut\Infrastructure\Tracking;

use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use Sut\Domain\Tracking\HttpClientInterface;
use Sut\Domain\Tracking\HttpResponse;

class HttpClient implements HttpClientInterface
{
    /**
     * @var ClientInterface
     */
    private $client;

    /**
     * @param ClientInterface $client
     */
    public function __construct(ClientInterface $client)
    {
        $this->client = $client;
    }

    /**
     * @param string $method
     * @param string $url
     * @param array $headers
     * @param string $body
     * @return HttpResponse
     * @throws GuzzleException
     */
    public function request(string $method, string $url, array $headers, string $body): HttpResponse
    {
        $options = ['headers' => $headers, 'body' => $body];
        $response = $this->client->request($method, $url, $options);

        return new HttpResponse($response->getStatusCode(), $response->getBody()->getContents());
    }
}
