<?php

namespace Container3I0Pxo6;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Sut_AppKernelProdContainer extends Container
{
    protected $containerDir;
    protected $targetDir;
    protected $parameters = [];
    private $buildParameters;

    public function __construct(array $buildParameters = [], $containerDir = __DIR__)
    {
        $this->buildParameters = $buildParameters;
        $this->containerDir = $containerDir;
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->fileMap = [
            'Sut\\Domain\\Compatibility\\GetMemoryPeakUsage' => 'getGetMemoryPeakUsageService',
            'Sut\\Domain\\Time\\TimerInterface' => 'getTimerInterfaceService',
            'Sut\\Domain\\Tracking\\Tracker' => 'getTrackerService',
            'Sut\\Infrastructure\\Entrypoint\\Command\\CheckCommand' => 'getCheckCommandService',
            'Sut\\Infrastructure\\Entrypoint\\Command\\RefactorCommand' => 'getRefactorCommandService',
            'Symfony\\Component\\Console\\Application' => 'getApplicationService',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function load($file, $lazyLoad = true)
    {
        if (class_exists($class = __NAMESPACE__.'\\'.$file, false)) {
            return $class::do($this, $lazyLoad);
        }

        if ('.' === $file[-4]) {
            $class = substr($class, 0, -4);
        } else {
            $file .= '.php';
        }

        $service = require $this->containerDir.\DIRECTORY_SEPARATOR.$file;

        return class_exists($class, false) ? $class::do($this, $lazyLoad) : $service;
    }

    /**
     * @return array|bool|float|int|string|\UnitEnum|null
     */
    public function getParameter(string $name)
    {
        if (isset($this->buildParameters[$name])) {
            return $this->buildParameters[$name];
        }

        if (!(isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters))) {
            throw new InvalidArgumentException(sprintf('The parameter "%s" must be defined.', $name));
        }
        if (isset($this->loadedDynamicParameters[$name])) {
            return $this->loadedDynamicParameters[$name] ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
        }

        return $this->parameters[$name];
    }

    public function hasParameter(string $name): bool
    {
        if (isset($this->buildParameters[$name])) {
            return true;
        }

        return isset($this->parameters[$name]) || isset($this->loadedDynamicParameters[$name]) || \array_key_exists($name, $this->parameters);
    }

    public function setParameter(string $name, $value): void
    {
        throw new LogicException('Impossible to call set() on a frozen ParameterBag.');
    }

    public function getParameterBag(): ParameterBagInterface
    {
        if (null === $this->parameterBag) {
            $parameters = $this->parameters;
            foreach ($this->loadedDynamicParameters as $name => $loaded) {
                $parameters[$name] = $loaded ? $this->dynamicParameters[$name] : $this->getDynamicParameter($name);
            }
            foreach ($this->buildParameters as $name => $value) {
                $parameters[$name] = $value;
            }
            $this->parameterBag = new FrozenParameterBag($parameters);
        }

        return $this->parameterBag;
    }

    private $loadedDynamicParameters = [
        'kernel.runtime_environment' => false,
        'kernel.build_dir' => false,
        'kernel.cache_dir' => false,
    ];
    private $dynamicParameters = [];

    private function getDynamicParameter(string $name)
    {
        switch ($name) {
            case 'kernel.runtime_environment': $value = $this->getEnv('default:kernel.environment:APP_RUNTIME_ENV'); break;
            case 'kernel.build_dir': $value = $this->targetDir.''; break;
            case 'kernel.cache_dir': $value = $this->targetDir.''; break;
            default: throw new InvalidArgumentException(sprintf('The dynamic parameter "%s" must be defined.', $name));
        }
        $this->loadedDynamicParameters[$name] = true;

        return $this->dynamicParameters[$name] = $value;
    }

    protected function getDefaultParameters(): array
    {
        return [
            'kernel.project_dir' => \dirname(__DIR__, 4),
            'kernel.environment' => 'prod',
            'kernel.debug' => false,
            'kernel.logs_dir' => (\dirname(__DIR__, 3).'/log'),
            'kernel.bundles' => [

            ],
            'kernel.bundles_metadata' => [

            ],
            'kernel.charset' => 'UTF-8',
            'kernel.container_class' => 'Sut_AppKernelProdContainer',
            'issuesConfig' => [
                'issues' => [
                    1121 => [
                        'message' => 'Extending from class \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1122 => [
                        'message' => 'Importing class \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1124 => [
                        'message' => 'Using class \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1123 => [
                        'message' => 'Loading class \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1111 => [
                        'message' => 'Extending from class \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1112 => [
                        'message' => 'Importing from class \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1114 => [
                        'message' => 'Using class \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1113 => [
                        'message' => 'Loading class \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1131 => [
                        'message' => 'Extending from class \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1132 => [
                        'message' => 'Importing from class \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1134 => [
                        'message' => 'Using class \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1133 => [
                        'message' => 'Loading class \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1104 => [
                        'message' => 'You are using \'%s\' class, please use interface \'%s\' instead',
                        'level' => 2,
                    ],
                    1224 => [
                        'message' => 'Using constant \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1226 => [
                        'message' => 'Assigning constant \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1225 => [
                        'message' => 'Overriding constant \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1214 => [
                        'message' => 'Using constant \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1216 => [
                        'message' => 'Assigning constant %s that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1215 => [
                        'message' => 'Overriding constant \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1234 => [
                        'message' => 'Using constant \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1236 => [
                        'message' => 'Assigning constant \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1235 => [
                        'message' => 'Overriding constant \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1327 => [
                        'message' => 'Inherited from interface \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1328 => [
                        'message' => 'Implemented interface \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1322 => [
                        'message' => 'Imported interface \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1324 => [
                        'message' => 'Used interface \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1317 => [
                        'message' => 'Inherited from interface \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1318 => [
                        'message' => 'Implemented interface \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1312 => [
                        'message' => 'Imported interface \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1314 => [
                        'message' => 'Used interface \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1337 => [
                        'message' => 'Inherited from interface \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1338 => [
                        'message' => 'Implemented interface \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1332 => [
                        'message' => 'Imported interface \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1334 => [
                        'message' => 'Used interface \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1428 => [
                        'message' => 'Possible dependency on implementation details. Usage of \'%s\' should be declared instead of \'%s\'',
                        'level' => 2,
                    ],
                    1429 => [
                        'message' => 'Call method \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1420 => [
                        'message' => 'Instantiating class/interface \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1410 => [
                        'message' => 'Call method \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1430 => [
                        'message' => 'Non declared method usage. Possibly DataObject magic method call: \'%s\'',
                        'level' => 3,
                    ],
                    1110 => [
                        'message' => 'Instantiating class/interface \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1439 => [
                        'message' => 'Call method \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1440 => [
                        'type' => 'MethodSignatureMismatch',
                        'level' => 3,
                    ],
                    1534 => [
                        'message' => 'Using property \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1536 => [
                        'message' => 'Assigning property \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1535 => [
                        'message' => 'Overriding property \'%s\' that is @deprecated on version \'%s\'',
                        'level' => 3,
                    ],
                    1524 => [
                        'message' => 'Using property \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1526 => [
                        'message' => 'Assigning property \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1525 => [
                        'message' => 'Overriding property \'%s\' that is non API on version \'%s\'',
                        'level' => 2,
                    ],
                    1514 => [
                        'message' => 'Using property \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1516 => [
                        'message' => 'Assigning property \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    1515 => [
                        'message' => 'Overriding property \'%s\' that does not exist on version \'%s\'',
                        'level' => 1,
                    ],
                    2001 => [
                        'message' => 'Core file \'%s\' was not found',
                        'level' => 1,
                    ],
                    2002 => [
                        'message' => 'Core file \'%s\' is modified',
                        'level' => 1,
                    ],
                    2003 => [
                        'message' => 'Composer dependency is not installed \'%s\'',
                        'level' => 1,
                    ],
                    2004 => [
                        'message' => 'Composer dependency versions mismatch for package \'%s\'. Vanilla: \'%s\'. Project: \'%s\'.',
                        'level' => 3,
                    ],
                    2005 => [
                        'message' => 'Core directory \'%s\' was not found',
                        'level' => 1,
                    ],
                    3101 => [
                        'type' => 'TYPE_REMOVED',
                        'level' => 1,
                    ],
                    3201 => [
                        'type' => 'TYPE_CHANGED_KIND',
                        'level' => 1,
                    ],
                    3102 => [
                        'type' => 'TYPE_REMOVED_FROM_UNION',
                        'level' => 1,
                    ],
                    3106 => [
                        'type' => 'VALUE_REMOVED_FROM_ENUM',
                        'level' => 1,
                    ],
                    3303 => [
                        'type' => 'REQUIRED_INPUT_FIELD_ADDED',
                        'level' => 1,
                    ],
                    3105 => [
                        'type' => 'IMPLEMENTED_INTERFACE_REMOVED',
                        'level' => 1,
                    ],
                    3103 => [
                        'type' => 'FIELD_REMOVED',
                        'level' => 1,
                    ],
                    3203 => [
                        'type' => 'FIELD_CHANGED_KIND',
                        'level' => 1,
                    ],
                    3307 => [
                        'type' => 'REQUIRED_ARG_ADDED',
                        'level' => 1,
                    ],
                    3107 => [
                        'type' => 'ARG_REMOVED',
                        'level' => 1,
                    ],
                    3207 => [
                        'type' => 'ARG_CHANGED_KIND',
                        'level' => 1,
                    ],
                    3109 => [
                        'type' => 'DIRECTIVE_REMOVED',
                        'level' => 1,
                    ],
                    3110 => [
                        'type' => 'DIRECTIVE_ARG_REMOVED',
                        'level' => 1,
                    ],
                    3310 => [
                        'type' => 'REQUIRED_DIRECTIVE_ARG_ADDED',
                        'level' => 1,
                    ],
                    3111 => [
                        'type' => 'DIRECTIVE_REPEATABLE_REMOVED',
                        'level' => 1,
                    ],
                    3112 => [
                        'type' => 'DIRECTIVE_LOCATION_REMOVED',
                        'level' => 1,
                    ],
                    3306 => [
                        'type' => 'VALUE_ADDED_TO_ENUM',
                        'level' => 3,
                    ],
                    3302 => [
                        'type' => 'TYPE_ADDED_TO_UNION',
                        'level' => 3,
                    ],
                    3304 => [
                        'type' => 'OPTIONAL_INPUT_FIELD_ADDED',
                        'level' => 3,
                    ],
                    3308 => [
                        'type' => 'OPTIONAL_ARG_ADDED',
                        'level' => 3,
                    ],
                    3305 => [
                        'type' => 'IMPLEMENTED_INTERFACE_ADDED',
                        'level' => 3,
                    ],
                    3206 => [
                        'type' => 'ARG_DEFAULT_VALUE_CHANGE',
                        'level' => 3,
                    ],
                    5002 => [
                        'type' => 'Generic.PHP.CharacterBeforePHPOpeningTag.Found',
                        'level' => 1,
                    ],
                    5003 => [
                        'type' => 'PHPCompatibility.FunctionUse.RemovedFunctions.Deprecated',
                        'level' => 1,
                    ],
                    5004 => [
                        'type' => 'Magento2.Functions.FunctionsDeprecatedWithoutArgument.FunctionsDeprecatedWithoutArgument',
                        'level' => 2,
                    ],
                    5005 => [
                        'type' => 'Generic.PHP.Syntax.PHPSyntax',
                        'level' => 1,
                    ],
                    5006 => [
                        'type' => 'Magento2.Classes.DiscouragedDependencies.ConstructorProxyInterceptor',
                        'level' => 3,
                    ],
                    5007 => [
                        'type' => 'Magento2.Functions.DiscouragedFunction.Discouraged',
                        'level' => 2,
                    ],
                    5009 => [
                        'type' => 'Magento2.Html.HtmlDirective.HtmlTemplatesProhibitedMethodCall',
                        'level' => 2,
                    ],
                    5010 => [
                        'type' => 'Magento2.Html.HtmlDirective.HtmlTemplatesInvalidVarsJSON',
                        'level' => 2,
                    ],
                    5011 => [
                        'type' => 'Magento2.Html.HtmlDirective.HtmlTemplatesInvalidVariableLabel',
                        'level' => 2,
                    ],
                    5012 => [
                        'type' => 'Magento2.Html.HtmlDirective.HtmlTemplatesUndefinedVariable',
                        'level' => 2,
                    ],
                    5013 => [
                        'type' => 'Magento2.Html.HtmlSelfClosingTags.HtmlSelfClosingNonVoidTag',
                        'level' => 2,
                    ],
                    5014 => [
                        'type' => 'Magento2.Legacy.ModuleXML.FoundObsoleteAttribute',
                        'level' => 2,
                    ],
                    5015 => [
                        'type' => 'Magento2.Legacy.DiConfig.FoundObsoleteParamNode',
                        'level' => 2,
                    ],
                    5016 => [
                        'type' => 'Magento2.Legacy.DiConfig.FoundObsoleteInstanceNode',
                        'level' => 2,
                    ],
                    5017 => [
                        'type' => 'Magento2.Legacy.DiConfig.FoundObsoleteArrayNode',
                        'level' => 2,
                    ],
                    5018 => [
                        'type' => 'Magento2.Legacy.DiConfig.FoundObsoleteItemNode',
                        'level' => 2,
                    ],
                    5019 => [
                        'type' => 'Magento2.Legacy.DiConfig.FoundObsoleteValueNode',
                        'level' => 2,
                    ],
                    5020 => [
                        'type' => 'Magento2.Legacy.WidgetXML.FoundObsoleteNodeSupportedBlocks',
                        'level' => 2,
                    ],
                    5021 => [
                        'type' => 'Magento2.Legacy.WidgetXML.FoundObsoleteNodeBlockName',
                        'level' => 2,
                    ],
                    5022 => [
                        'type' => 'Magento2.Legacy.WidgetXML.FoundFactory',
                        'level' => 2,
                    ],
                    5023 => [
                        'type' => 'Magento2.Legacy.ObsoleteAcl.ObsoleteAclStructure',
                        'level' => 2,
                    ],
                    5024 => [
                        'type' => 'Magento2.Legacy.ObsoleteMenu.ObsoleteMenuStructure',
                        'level' => 2,
                    ],
                    5025 => [
                        'type' => 'Magento2.Legacy.ObsoleteSystemConfiguration.FoundObsoleteSystemConfiguration',
                        'level' => 2,
                    ],
                    5026 => [
                        'type' => 'Magento2.Legacy.PhtmlTemplate.TextJavascriptTypeFound',
                        'level' => 2,
                    ],
                    5028 => [
                        'type' => 'Magento2.Legacy.PhtmlTemplate.ProtectedPrivateBlockAccess',
                        'level' => 2,
                    ],
                    5031 => [
                        'type' => 'Magento2.Legacy.ObsoleteConnection.ObsoleteMethodFound',
                        'level' => 2,
                    ],
                    5042 => [
                        'type' => 'Magento2.Legacy.ClassReferencesInConfigurationFiles.IncorrectClassReference',
                        'level' => 2,
                    ],
                    5043 => [
                        'type' => 'Magento2.Legacy.ClassReferencesInConfigurationFiles.IncorrectModuleReference',
                        'level' => 2,
                    ],
                    5044 => [
                        'type' => 'Magento2.Legacy.RestrictedCode.ZendDbSelectIsRestricted',
                        'level' => 2,
                    ],
                    5045 => [
                        'type' => 'Magento2.Legacy.RestrictedCode.ZendDbAdapterPdoMysqlIsRestricted',
                        'level' => 2,
                    ],
                    5046 => [
                        'type' => 'Magento2.Legacy.RestrictedCode.SerializerSerializeIsRestricted',
                        'level' => 2,
                    ],
                    5047 => [
                        'type' => 'Magento2.Legacy.RestrictedCode.ArrayObjectIsRestricted',
                        'level' => 2,
                    ],
                    5048 => [
                        'type' => 'Magento2.Legacy.RestrictedCode.ArrayObjectFactoryIsRestricted',
                        'level' => 2,
                    ],
                    5050 => [
                        'type' => 'Magento2.Legacy.Layout.ObsoleteBlock',
                        'level' => 2,
                    ],
                    5051 => [
                        'type' => 'Magento2.Legacy.Layout.ObsoleteToHtmlAttribute',
                        'level' => 2,
                    ],
                    5052 => [
                        'type' => 'Magento2.Legacy.Layout.ObsoleteClass',
                        'level' => 2,
                    ],
                    5053 => [
                        'type' => 'Magento2.Legacy.Layout.MethodNotAllowed',
                        'level' => 2,
                    ],
                    5054 => [
                        'type' => 'Magento2.Legacy.Layout.CharacterNotAllowedInAttribute',
                        'level' => 2,
                    ],
                    5055 => [
                        'type' => 'Magento2.Legacy.Layout.CharacterExpectedInAttribute',
                        'level' => 2,
                    ],
                    5056 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteInstallScript',
                        'level' => 2,
                    ],
                    5057 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteInstallSchemaScript',
                        'level' => 2,
                    ],
                    5058 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteInstallDataScript',
                        'level' => 2,
                    ],
                    5059 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteDataInstallScript',
                        'level' => 2,
                    ],
                    5060 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteUpgradeScript',
                        'level' => 2,
                    ],
                    5061 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteUpgradeSchemaScript',
                        'level' => 2,
                    ],
                    5062 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteUpgradeDataScript',
                        'level' => 2,
                    ],
                    5063 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteDataUpgradeScript',
                        'level' => 2,
                    ],
                    5064 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.ObsoleteRecurringScript',
                        'level' => 2,
                    ],
                    5065 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.DataInvalidDirectory',
                        'level' => 2,
                    ],
                    5066 => [
                        'type' => 'Magento2.Legacy.InstallUpgrade.SqlInvalidDirectory',
                        'level' => 2,
                    ],
                    5067 => [
                        'type' => 'Magento2.Legacy.ObsoleteConfigNodes.ObsoleteNodeInConfig',
                        'level' => 2,
                    ],
                    5068 => [
                        'type' => 'Magento2.Legacy.EmailTemplate.FoundObsoleteHtmlescapeDirective',
                        'level' => 2,
                    ],
                    5069 => [
                        'type' => 'Magento2.Legacy.EmailTemplate.FoundObsoleteEscapehtmlDirective',
                        'level' => 2,
                    ],
                    5070 => [
                        'type' => 'Magento2.Legacy.AbstractBlock.ThirdParameterNotNeeded',
                        'level' => 2,
                    ],
                    5071 => [
                        'type' => 'Magento2.Legacy.AbstractBlock.FourthParameterNotNeeded',
                        'level' => 2,
                    ],
                    5072 => [
                        'type' => 'Magento2.Legacy.MageEntity.FoundLegacyEntity',
                        'level' => 1,
                    ],
                    5073 => [
                        'type' => 'Magento2.Legacy.TableName.FoundLegacyTableName',
                        'level' => 2,
                    ],
                    5074 => [
                        'type' => 'Magento2.Methods.DeprecatedModelMethod.FoundDeprecatedModelMethod',
                        'level' => 3,
                    ],
                    5075 => [
                        'type' => 'Magento2.Namespaces.ImportsFromTestNamespace.WrongImport',
                        'level' => 2,
                    ],
                    5076 => [
                        'type' => 'Magento2.NamingConvention.ReservedWords.ForbiddenAsNameSpace',
                        'level' => 1,
                    ],
                    5077 => [
                        'type' => 'Magento2.NamingConvention.ReservedWords.ForbiddenAsClassName',
                        'level' => 1,
                    ],
                    5078 => [
                        'type' => 'Magento2.PHP.AutogeneratedClassNotInConstructor.AutogeneratedClassNotInConstructor',
                        'level' => 2,
                    ],
                    5079 => [
                        'type' => 'Magento2.PHP.Var.FoundVar',
                        'level' => 2,
                    ],
                    5080 => [
                        'type' => 'Magento2.SQL.RawQuery.FoundRawSql',
                        'level' => 2,
                    ],
                    5081 => [
                        'type' => 'Magento2.Templates.ThisInTemplate.FoundHelper',
                        'level' => 2,
                    ],
                    5082 => [
                        'type' => 'Magento2.Templates.ThisInTemplate.FoundThis',
                        'level' => 2,
                    ],
                    5083 => [
                        'type' => 'Magento2.Translation.ConstantUsage.VariableTranslation',
                        'level' => 2,
                    ],
                    5085 => [
                        'type' => 'Magento2.Functions.DiscouragedFunction.DiscouragedWithAlternative',
                        'level' => 2,
                    ],
                    5086 => [
                        'type' => 'PHPCompatibility.FunctionUse.RemovedFunctions.Removed',
                        'level' => 1,
                    ],
                    5087 => [
                        'type' => 'PHPCompatibility',
                        'level' => 2,
                    ],
                    5088 => [
                        'type' => 'Magento2.PHPCompatibility',
                        'level' => 2,
                    ],
                    6001 => [
                        'type' => 'jquery-no-andSelf',
                        'level' => 2,
                    ],
                    6002 => [
                        'type' => 'jquery-no-bind-unbind',
                        'level' => 2,
                    ],
                    6003 => [
                        'type' => 'jquery-no-input-event-shorthand',
                        'level' => 2,
                    ],
                    6004 => [
                        'type' => 'jquery-no-delegate-undelegate',
                        'level' => 2,
                    ],
                    6005 => [
                        'type' => 'jquery-no-event-shorthand',
                        'level' => 2,
                    ],
                    6006 => [
                        'type' => 'jquery-no-size',
                        'level' => 2,
                    ],
                    6007 => [
                        'type' => 'jquery-no-trim',
                        'level' => 2,
                    ],
                    6008 => [
                        'type' => 'no-restricted-syntax',
                        'level' => 2,
                    ],
                    6009 => [
                        'type' => 'jquery-no-misc-deprecated-functions',
                        'level' => 2,
                    ],
                    6010 => [
                        'type' => 'jquery-no-deprecated-expr',
                        'level' => 2,
                    ],
                ],
            ],
            'schemaVerificationPath' => (\dirname(__DIR__, 4).'/graphql-schema-compatibility/js/index.js'),
            'outputPath' => (\dirname(__DIR__, 3).'/output/%s-results.json'),
            'errorCodesDocumentation' => 'https://experienceleague.adobe.com/docs/commerce-operations/upgrade-guide/upgrade-compatibility-tool/error-messages.html',
            'documentationLink' => 'https://experienceleague.adobe.com/docs/commerce-operations/upgrade-guide/upgrade-compatibility-tool/overview.html',
        ];
    }
}
