# Magento API Index

Magento API Index is a library containing index of Adobe Commerce versions codebase and providing tools for retrieving information from these indexes.

## Installation

Magento API Index is a library that used by [UCT](https://github.com/magento-commerce/uct). However, if for some reason you'd like to use it independently you can install it in the following ways:

- clone repository from GitHub - `git clone git@github.com:magento-commerce/magento-api-index.git`
or
- install as Composer dependency for project `composer require magento/magento-api-index:<version>`
or
- install as Composer global library `composer global require magento/magento-api-index:<version>`

## CLI Usage

Magento API Index package provides CLI interface allowing to browse the indexes contents.

Running `bin/magento-api-index` command will list all commands provided by the library.

```
$ ./bin/magento-api-index
```

```
Magento 2 API Index. 5.2.0

Usage:
  command [options] [arguments]

Options:
  -h, --help            Display help for the given command. When no command is given display help for the list command
  -q, --quiet           Do not output any message
  -V, --version         Display this application version
      --ansi|--no-ansi  Force (or disable --no-ansi) ANSI output
  -n, --no-interaction  Do not ask any interactive question
  -v|vv|vvv, --verbose  Increase the verbosity of messages: 1 for normal output, 2 for more verbose output and 3 for debug

Available commands:
  completion           Dump the shell completion script
  help                 Display help for a command
  list                 List commands
 api
  api:check            Allow to check if an element is part of Adobe Commerce API.
  api:describe         Read information for an element of Adobe Commerce API. If the element is not part of Adobe Commerce API 100 status code is returned.
  api:diff             Allow to list Adobe Commerce API differences between two selected versions.
Available versions: 2.3.0 | 2.3.1 | 2.3.2 | 2.3.2-p2 | 2.3.3 | 2.3.3-p1 | 2.3.4 | 2.3.4-p1 | 2.3.4-p2 | 2.3.5 | 2.3.5-p1 | 2.3.5-p2 | 2.3.6 | 2.3.6-p1 | 2.3.7 | 2.3.7-p1 | 2.3.7-p2 | 2.3.7-p3 | 2.4.0 | 2.4.0-p1 | 2.4.1 | 2.4.1-p1 | 2.4.2 | 2.4.2-p1 | 2.4.2-p2 | 2.4.3 | 2.4.3-p1 | 2.4.3-p2 | 2.4.4
 component
  component:libraries  Allows fetching a list of framework components available in the Adobe Commerce release.
  component:library    Allows verifying if the framework component is a part of Adobe Commerce release and if yes returns it data. If the framework component is not part of Adobe Commerce release 100 status code is returned.
  component:module     Allows verifying if the module is a part of Adobe Commerce release and if yes returns it data. If the module is not part of Adobe Commerce release 100 status code is returned.
  component:modules    Allows fetching a list of modules available in the Adobe Commerce release.
  component:theme      Allows verifying if the theme is a part of Adobe Commerce release and if yes returns it data. If the theme is not part of Adobe Commerce release 100 status code is returned.
  component:themes     Allows fetching a list of themes available in the Adobe Commerce release.
```

`magento-api-index` allows to obtain various information about all released Magento versions.

## API commands

`api` commands allows to obtain various information about all released Magento API versions. As arguments, provide release and fully qualified namespace of the API element. **Remember to escape all backslash characters in API element namespace**.

### `api:check` command

`api:check` allows to check if the code reference is prefesent, marked as API or deprecated on specific Adobe Commerce version:

```
$ ./bin/magento-api-index api:check 2.4.4 Magento\\Framework\\Api\\CustomAttributesDataInterface::setCustomAttributes
Magento\Framework\Api\CustomAttributesDataInterface::setCustomAttribute is present in the index for version 2.4.4
Magento\Framework\Api\CustomAttributesDataInterface::setCustomAttribute is API on version 2.4.4
Magento\Framework\Api\CustomAttributesDataInterface::setCustomAttribute is not deprecated on version 2.4.4
```

### `api:describe` command

`api:describe` allows to obtain detailed information about Magento API element:

```
$ ./bin/magento-api-index api:describe 2.4.4 Magento\\Framework\\Api\\CustomAttributesDataInterface::setCustomAttributes
{
    "kind": "method",
    "fqsen": "Magento\\Framework\\Api\\CustomAttributesDataInterface::setCustomAttribute",
    "owner": "Magento\\Framework\\Api\\CustomAttributesDataInterface",
    "name": "setCustomAttribute",
    "flags": 1,
    "scope": "public",
    "static": false,
    "abstract": false,
    "final": false,
    "params": [
        {
            "name": "attributeCode",
            "type": {
                "expr": "string"
            },
            "flags": 0,
            "variadic": false,
            "optional": false
        },
        {
            "name": "attributeValue",
            "type": {
                "expr": "mixed"
            },
            "flags": 0,
            "variadic": false,
            "optional": false
        }
    ],
    "returns": {
        "expr": "$this"
    },
    "api": {
        "since": "100.0.2"
    }
}

```

### `api:diff` command

This command can be used to display differences between two Adobe Commerce versions.

Results will include only references that are present, are marked as api or deprecated only on one of the versions.

```
$ ./bin/magento-api-index api:diff 2.4.4 2.4.3
(...)

Dotdigitalgroup\Email\Block\Adminhtml\Rules::escapeCss                                                Present only in 2.4.3
Dotdigitalgroup\Email\Block\Adminhtml\Studio::getLayout                                               Present only in 2.4.3  API only in 2.4.3
Dotdigitalgroup\Email\Block\Customer\Account\Books::escapeQuote                                       Present only in 2.4.3  API only in 2.4.3  deprecated only in 2.4.3
Dotdigitalgroup\Email\Block\Edc::fetchView                                                            Present only in 2.4.3
Dotdigitalgroup\Email\Block\Recommended\Bestsellers::getAddToWishlistParams                           Present only in 2.4.3  API only in 2.4.3  deprecated only in 2.4.3
Dotdigitalgroup\Email\Block\Recommended\Mostviewed::getChildBlock                                     Present only in 2.4.3  API only in 2.4.3
Magento\InventoryImportExport\Plugin\Import\UpdateConfigurableProductsPlugin                          Present only in 2.4.4

(...)

Total number of checked API entries: 521268
Total number of differences between versions: 38699
```

### `component` commands

`component` commands allow to obtain information about libraries, themes and modules stored in the index.

To see the list of all themes, execute following command, as an argument provide Magento release:
```
$ ./bin/magento-api-index component:themes 2.4.4
{
    "adminhtml\/magento\/backend": {
        "identifier": "dfc_Pyb_m4godbsWNsEpLw",
        "distributionPackage": "magento\/theme-adminhtml-backend",
        "version": "100.4.4"
    },
    "frontend\/magento\/blank": {
        "identifier": "frontend\/Magento\/blank",
        "distributionPackage": "magento\/theme-frontend-blank",
        "version": "100.4.4"
    },
    "frontend\/magento\/luma": {
        "identifier": "frontend\/Magento\/luma",
        "distributionPackage": "magento\/theme-frontend-luma",
        "version": "100.4.4"
    }
}
```

You can get detailed information about selected theme using the following command (first argument is the release followed by theme name)
```
$ ./bin/magento-api-index component:module 2.4.4 Magento_Catalog
{
    "identifier": "Magento_Catalog",
    "distributionPackage": "magento\/module-catalog",
    "version": "104.0.4",
    "namespaces": [
        "Magento\\Catalog\\"
    ]
}
```

## Programmatic Usage

### Access information stored in the index for specific version

`Magento\Mray\MagentoApiIndex\Index\Version` class instance should be created to get access to the index infomration of specific version.

```php

// include Version class in your code
use Magento\Mray\MagentoApiIndex\Index\Version;

// create an instance, as an argument pass Magento release version:
$version = new Version('2.4.4');

// check if provided fully qualified name of a class/method is a part of Magento API:
$version->isApi('Magento\Framework\Search\Request\Query\Match');

// obtain details about Magento API declaration:
$version->getApiDeclaration('Magento\Framework\Search\Request\Query\Match');

// verify if Magento API element is deprecated:
$version->isDeprecated('Magento\Framework\Search\Request\Query\Match');

// obtain details about deprecation declaration:
$version->getDeprecationDeclaration('Magento\Framework\Search\Request\Query\Match');

// get details about Magento API element - this returns the same result as 
// command-line api:describe command:
$version->describe('Magento\Framework\Search\Request\Query\Match');
```

### `GetIndexedVersions` API

`GetIndexedVersions` API allows to obtain a list of all Magento API versions available in Magento API Index. To use it in your code, follow the example:

```php

use Magento\Mray\MagentoApiIndex\Api\GetIndexedVersions;

$releases = (new GetIndexedVersions())->execute();
```

`$releases` will contain an array, where every element is an identifier of available MAgento API release (eg. '2.3.7', '2.4.2-p1' etc.)

### magento-api-index Release Guide

For detailed information about how to release magento-api-index, visit [RELEASE_GUIDE](https://github.com/magento-commerce/magento-api-index/blob/develop/RELEASE_GUIDE.md) page.
