# M-ray

M-ray is a library designed to parse Adobe Commerce projects and extract all improtant data for the analysis of Adobe Commerce code usage.

# Usage

## Generate Adobe Commerce release index

All Adobe Commerce-based projects share a lot of common code. Source code static analysis may consume a lot of resources and 
time on a project of such size as Adobe Commerce is. To optimize resources usage and improve performance of code discovery,
M-ray provides a set of PHP and CLI APIs that may be used to index Adobe Commerce core source code, so all custom projects 
may use this data later and analyse only code unique to particular project.

### Download the complete vanilla Adobe Commerce codebase

To generate a complete index an Adobe Commerce release it should be downloaded to the local filesystem.

MRay provides `mray download:magento` CLI command to fetch required Adobe Commerce with all its dependencies.

Usage:

```
mray download:magento <version> <dir>
```

The following command will download the Adobe Commerce of specified version into the specified directory.

The dowloaded Adobe Commerce version will include:
 - Magento Open Source modules
 - Adobe Commerce modules
 - B2B modules
 - Magento Bundled Extensions
 - Vendor Bundled Extensions
 - Magento modules included in Cloud distribution
 - Sample Data modules
 
### Generate the release index

Once an Adobe Commerce release is available locally it may be indexed with the following command:

```
mray indexer:index-magento-releases <directory with Magento release(s)> <data directory>
```

 - The `directory with Magento release(s)` may be the root directory of a single Adobe Commerce release or directory containing multiple releases
 - MRay is used to generate the release index for future distribution as part of `magento/magento-api-index` package. So `data directory` in usual use case scenario should be pointed to the `data` folder of the Magento API Index proejct.

The indexer will append the index of passed release(s) to the release indexes stored in the data directory.
If the index is generated for the version already stored in the data directory, possible new information will be appended, however, the information already stored will not be removed even if the new version of MRay index provide less information.

## Scan Adobe Commerce-based Projects
 
M-ray allows scanning Adobe Commerce-based projects to discover dependencies on the Adobe Commerce code.

Information about customizations may be generated with following PHP code:

```php
$result = (new Magento\Mray\Api\CustomProjectIndex())->execute($path, $version);
$customizations = $result->getCustomizations();
// $customizations['modules']['CustomVendor_CustomModule']['dependencies'] = ['Magento\Catalog\Model\Product' => [details on how the class is used]]
``` 

`Magento\Mray\Api\Data\CustomProjectIndexResult::getCustomizations()` returns an array containing all detected custom `modules`, `libraries`, `themes` and all the references to the core code identified in scope of these components.

Note: Scanning `libraries` and `themes` is not currently supported.

Adobe Commerce API index may be used to estimate different types of usages:

```php
$magentoApiIndexFacade = new Magento\Mray\MagentoApiIndex\Api();
$magentoApiIndex = $magentoApiIndexFacade->getApiIndex($currentProjectMagentoEdition);

foreach ($customizations as $componentType => $components) {
    foreach ($components as $component) {
        foreach ($component['dependencies'] as $externalCodeElementFQSEN => $usageInfo) {
            $isApi = $magentoApiIndex->isApi($externalCodeElementFQSEN); // bool
            $apiDeclarationData = $magentoApiIndex->getApiDeclaration($externalCodeElementFQSEN); // array|null
            $idDeprecated = $magentoApiIndex->isDeprecated($externalCodeElementFQSEN); // bool
            $deprecationData = $magentoApiIndex->getDeprecationDeclaration($externalCodeElementFQSEN); // array|null
            $allCodeElementInfo = $magentoApiIndex->describe($externalCodeElementFQSEN); // array|null
        }
    }
}
```

If needed, multiple instances of `Magento\Mray\MagentoApiIndex\ApiIndex` may be used at the same time to estimate if used element changes between different Adobe Commerce releases.
`$usageInfo` also contains `type` property that describe which type of the element is and `realName` which describes with which FQSEN code element is declared in a code. It may be different in case class member (method, property or class constant) is used on a child class.

## Implement Own Scanner

With `Magento\Mray\Api\MagentoIndexEngine` it easy to implement own scanner and get more information from source code.

It accepts lists of tuners (must implement `Magento\Mray\Index\Scanner\Tuner`) and visitors (must implement `Magento\Mray\Index\Traverser\NodeVisitor`);

Tuners are used during collecting information about available components and its elements and should be used to:
- filter out discovered components
- optimize filesystem traversing
- read declarations that have global scope (e.g. PHP classes and interfaces declarations)

Visitors traverse final tree of the discovered components and should be used to:
- read information from the nodes that represents components and its elements
- estimate runtime types (e.g. types of PHP variables)

Check implementation of provided indexers fo examples.

## Download repo packages

The following command will download the latest available stable version of required packages from repo.magento.com into specified directory, installing their dependencies if requested using `--install` option.

```
mray crawler:download-repo-packages \
    --source=https://repo.magento.com/ \
    --auth=<path to auth.json file with access keys for repo.magento.com> \
    --require="vendor/package-name:2.*" \
    --require="vendor/another-package-name:^2" \
    --install \
    --minimum-stability=stable \
<dir>
```

This example will download all matching versions of `vendor/package-name` and `vendor/another-package-name` via composer to `<dir>`.

A great use case of `mray crawler:download-repo-packages` is downloading all extensions present in the repo.magento.com. This may be required for performing [TCO analysis](https://wiki.corp.adobe.com/display/MC/TCO+Analysis+Guide).

```
bin/mray crawler:download-repo-packages \
    --source=https://repo.magento.com/ \
    --auth=<path to auth.json file with access keys for repo.magento.com> \
    --minimum-stability=stable \
<dir>
```

This example will download all stable versions of packages from repo.magento.com to `<dir>`.

