# Upload a new MRay version to repo.magento.com

1. Modify `composer.json` and update `version` to the new version number. Increment Major, minor or patch version depending on the level of changes since the latest release.
   

2. Go to https://github.com/magento-commerce/mray/releases and create a new release, tagging it with the version number
   specified in `composer.json`.
   

3. Download the zip of that release from the same https://github.com/magento-commerce/mray/releases.
   

4. Create the release in repo.magento.com (You need the Magento or Adobe VPN enabled)
   
      Go to `repo.magento.com -> Releases -> Core Releases -> (+)Add New` or navigate to https://repo.magento.com/admin/packagist/web/ceeerelease/create

   Fill the form with the following information:
   
   - Name: magento/mray-VERSION
   - Availability Groups: Internal

   > Example of a `create release`
   
   ![Create Release](images/createrelease.png)


5. Upload the zip from step 3

   Go to `repo.magento.com -> Packages -> Uploda Core M2 Version` or navigate to https://repo.magento.com/admin/upload_m2_version
   
   Fill the form with the following information:

   - Extension package: `mray-version.zip`
   - Release: magento/mray-VERSION
   - Edition: EE

   > Example of a `upload package`
   
   ![Upload version](images/uploadversion.png)


6. Make the release publicly available

   Go to `repo.magento.com -> Releases -> Core Releases` and click `Edit` next to the created release (filter the grid by name if the release is not visible).
   
   On the release edit form, update the "Availability Groups" field removing `Internal` and adding `External` instead.

   ![Set release as EXTERNAL](images/setreleaseasexternal.png)
