<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Integration;

use Magento\Mray\Model\Xml\GetXmlFileContent;
use PHPUnit\Framework\TestCase;

class GetDbSchemaXmlFileContentTest extends TestCase
{
    /**
     * @var GetXmlFileContent
     */
    private $dbSchemaXmlService;

    protected function setUp(): void
    {
        $this->dbSchemaXmlService = new GetXmlFileContent();
    }

    /**
     * @param string $modulePath
     * @param array $expectedFilePaths
     * @dataProvider moduleProvider
     */
    public function testExecute(string $modulePath, array $expectedFilePaths): void
    {
        $fileContents = $this->dbSchemaXmlService->execute($modulePath, 'db_schema.xml');

        $this->assertCount(count($expectedFilePaths), $fileContents);

        foreach ($fileContents as $path => $content) {
            $this->assertContains($path, $expectedFilePaths);
            $this->assertStringEqualsFile($path, $content);
        }
    }

    /**
     * @return array[]
     */
    public function moduleProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/test-module/module',
                [
                    __DIR__ . '/_files/test-module/module/etc/db_schema.xml',
                ]
            ],
            [
                __DIR__ . '/_files/test-module/abcde/',
                []
            ]
        ];
    }
}
