<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Integration;

use Magento\Mray\Model\Xml\GetXmlFileContent;
use PHPUnit\Framework\TestCase;

class GetProjectRootDbSchemaXmlFileContentTest extends TestCase
{
    /**
     * @var GetXmlFileContent
     */
    private $dbSchemaXmlService;

    protected function setUp(): void
    {
        $this->dbSchemaXmlService = new GetXmlFileContent();
    }

    /**
     * @param string $projectPath
     * @param string $expectedFilePaths
     * @dataProvider projectProvider
     */
    public function testExecute(string $projectPath, string $expectedFilePath): void
    {
        $fileContent = $this->dbSchemaXmlService->execute($projectPath . '/app', 'db_schema.xml');
        $this->assertStringEqualsFile($expectedFilePath, current($fileContent));
    }

    /**
     * @return array[]
     */
    public function projectProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/magentoReleases/project1',
                __DIR__ . '/_files/magentoReleases/project1/app/etc/db_schema.xml',
            ]
        ];
    }
}
