<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Integration;

use Magento\Mray\Model\Xml\GetXmlFileContent;
use PHPUnit\Framework\TestCase;

class GetProjectRootDiXmlFileContentsTest extends TestCase
{
    /**
     * @var GetXmlFileContent
     */
    private $diXmlService;

    protected function setUp(): void
    {
        $this->diXmlService = new GetXmlFileContent();
    }

    /**
     * @param string $projectPath
     * @param string $expectedFilePath
     * @dataProvider projectProvider
     */
    public function testExecute(string $projectPath, string $expectedFilePath): void
    {
        $fileContent = $this->diXmlService->execute($projectPath . '/app', 'di.xml');
        $this->assertStringEqualsFile($expectedFilePath, current($fileContent));
    }

    /**
     * @return array[]
     */
    public function projectProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/magentoReleases/project1',
                __DIR__ . '/_files/magentoReleases/project1/app/etc/di.xml',
            ]
        ];
    }
}
