<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Integration;

use Magento\Mray\Api\CustomProjectIndex;
use Magento\Mray\Api\GetProjectVersion;
use PHPUnit\Framework\TestCase;

class GetProjectVersionTest extends TestCase
{
    /**
     * @var GetProjectVersion
     */
    private $getProjectVersion;

    public function setUp(): void
    {
        $this->getProjectVersion = new GetProjectVersion();
    }

    /**
     * @param string $path
     * @param string $version
     * @dataProvider projectsProvider
     */
    public function testExecute(
        string $path,
        string $version
    ) {
        $this->assertEquals($version, $this->getProjectVersion->execute($path));
    }

    /**
     * @return array[]
     */
    public function projectsProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/customProjects/project2',
                '2.4.3'
            ],
            [
                __DIR__ . '/_files/customProjects/project1',
                '2.4.0'
            ]
        ];
    }

    /**
     * @param string $path
     * @param string $exception
     * @dataProvider exceptionsProvider
     */
    public function testExecuteException(
        string $path,
        string $exception
    ) {
        $this->expectException($exception);
        $this->getProjectVersion->execute($path);
    }

    /**
     * @return array[]
     */
    public function exceptionsProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/customProjects/project1/Vendor/Module',
                \RuntimeException::class
            ],
            [
                __DIR__ . '/_files/customProjects/',
                \RuntimeException::class
            ]
        ];
    }
}
