<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Integration;

use Magento\Mray\Api\CustomProjectIndex;
use PHPUnit\Framework\TestCase;

class MethodSignatureTest extends TestCase
{
    /**
     * @param string $path
     * @param string $version
     * @param array $dependencies
     * @dataProvider projectsProvider
     */
    public function testCustomProjectIndex(
        string $path,
        string $version,
        array $dependencies
    ) {
        $actualDependencies = (new CustomProjectIndex())->execute($path, $version)
            ->getCustomizations()['modules'][0]['dependencies'];

        foreach ($dependencies as $dependency => $usages) {
            $actualUsages = $actualDependencies[$dependency]['usage'];
            foreach ($usages as $usage => $signature) {
                $this->assertEquals($signature['arguments'], $actualUsages[$usage][0]['arguments']);
                $this->assertEquals($signature['returnType'], $actualUsages[$usage][0]['returnType']);
            }
        }
    }

    /**
     * @return array[]
     */
    public function projectsProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/customProjects/project5/Vendor/ExtendedModule',
                '2.4.0',
                [
                    'Magento\Catalog\Api\ProductRepositoryInterface::get' => [
                        'extend' => [
                            'arguments' => [
                                [
                                    'name' => 'sku',
                                    'type' => 'string',
                                    'optional' => false
                                ],
                                [
                                    'name' => 'editMode',
                                    'type' => 'bool',
                                    'optional' => true
                                ],
                                [
                                    'name' => 'storeId',
                                    'type' => '(int|null)',
                                    'optional' => true
                                ],
                                [
                                    'name' => 'forceReload',
                                    'type' => 'bool',
                                    'optional' => true
                                ]
                            ],
                            'returnType' => 'string'
                        ]
                    ]
                ],
            ]
        ];
    }
}
