<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Integration;

use Magento\Mray\Api\CustomProjectIndex;
use PHPUnit\Framework\TestCase;

class UsageCallArgumentsTest extends TestCase
{
    /**
     * @var CustomProjectIndex
     */
    private $index;

    public function setUp(): void
    {
        $this->index = new CustomProjectIndex();
    }

    /**
     * @param string $path
     * @param string $version
     * @param array $modules
     * @dataProvider usageArrayProvider
     */
    public function testExecute(
        string $path,
        string $version,
        array $usageArray
    ) {
        $result = $this->index->execute($path, $version);
        foreach ($result->getCustomizations()['modules'][0]['dependencies'] as $dependency) {
            if (array_key_exists('call', $dependency['usage'])) {
                foreach ($dependency['usage']['call'] as $call) {
                    $this->assertEquals($call['arguments'], array_pop($usageArray));
                }
            }
        }
    }

    /**
     * @return array[]
     */
    public function usageArrayProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/customProjects/project4/Vendor/Module2',
                '2.4.0',
                [
                    [
                        [
                            "type" => "\Magento\Catalog\Api\ProductRepository",
                            "value" => null
                        ]
                    ],
                    [
                        [
                            "type" => "int",
                            "value" => 2
                        ],
                        [
                            "type" => "int",
                            "value" => 3
                        ],
                        [
                            "type" => "string",
                            "value" => "test3"
                        ]
                    ],
                    [
                        [
                            "type" => "string",
                            "value" => "test1"
                        ],
                        [
                            "type" => "string",
                            "value" => "test2"
                        ]
                    ],
                    [
                        [
                            "type" => "int",
                            "value" => 1
                        ]
                    ],
                ]
            ]
        ];
    }
}
