<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Vendor\Module2\Model;

use Magento\Catalog\Api\ProductRepositoryInterface;

class TestClass
{
    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    public function __construct(ProductRepositoryInterface $product)
    {
        $this->productRepository = $product;
    }

    public function execute()
    {
        // usages:
        $this->productRepository->get(1);
        $this->productRepository->get('test1', 'test2');
        $this->productRepository->get(2, 3, 'test3');
        $this->productRepository->get(new \Magento\Catalog\Api\ProductRepository);
    }
}
