<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Memorized;
use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Memorizing;
use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;
use PHPUnit\Framework\TestCase;

class MemorizedTest extends TestCase
{
    public function testMemorizedValueIsReturned()
    {
        $typeStub = new class implements Type {
            public function __toString(): string
            {
                return 'stub';
            }
        };
        $node = $this->createNodeStub();
        $node->{Memorizing::NODE_RESOLVED_TYPE} = $typeStub;

        $resolver = new Memorized();
        $returnedType = $resolver->resolve($node);

        $this->assertEquals($typeStub, $returnedType, 'Memorized resolver should return memorized type.');
    }

    public function testFallbackToMixedWithoutMemorizedValue()
    {
        $node = $this->createNodeStub();
        $resolver = new Memorized();
        $returnedType = $resolver->resolve($node);

        $this->assertEquals('mixed', (string)$returnedType, 'Memorized resolver should fallback to mixed type.');
    }

    private function createNodeStub(): Expr
    {
        return new class extends Expr {
            public function getType(): string
            {
                return 'Test_Expr';
            }
            public function getSubNodeNames(): array
            {
                return [];
            }
        };
    }
}
