<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Memorizing;
use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Resolver;
use phpDocumentor\Reflection\Type;
use PhpParser\Node\Expr;
use PHPUnit\Framework\TestCase;

class MemorizingTest extends TestCase
{
    public function testTypeIsMemorized()
    {
        $typeStub = new class implements Type {
            public function __toString(): string
            {
                return 'stub';
            }
        };
        $resolver = new Memorizing(new class ($typeStub) implements Resolver {
            /** @var Type */
            private $type;
            public function __construct(Type $type)
            {
                $this->type = $type;
            }
            public function resolve(Expr $expr): Type
            {
                return $this->type;
            }
        });
        $node = new class extends Expr {
            public function getType(): string
            {
                return 'Test_Expr';
            }
            public function getSubNodeNames(): array
            {
                return [];
            }
        };

        $returnedType = $resolver->resolve($node);

        $this->assertEquals($typeStub, $returnedType, 'Memorizing resolver should pass resolved value.');
        $this->assertTrue(
            isset($node->{Memorizing::NODE_RESOLVED_TYPE}),
            'Memorizing resolver should add information about type to the node.'
        );
        $this->assertEquals(
            $returnedType,
            $node->{Memorizing::NODE_RESOLVED_TYPE},
            'Memorizing resolver should leave remember return type.'
        );
    }
}
