<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\CodeStructuralElement\Php\NodeRuntimeTypeResolver;

use Exception;
use Magento\Mray\CodeStructuralElement\Php\NodeRuntimeTypeResolver\Ruleset;
use PhpParser\Node\Expr;
use PHPUnit\Framework\TestCase;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use ReflectionClass;
use function dirname;
use function in_array;
use function sprintf;
use function str_replace;

class RulesetTest extends TestCase
{
    /**
     * @param string $exprClass
     *
     * @dataProvider expressions
     */
    public function testDefaultHasFullCoverage(string $exprClass)
    {
        if (in_array($exprClass, [
            // add class names here if needed
        ])) {
            $this->markTestSkipped(sprintf("Support of %s is not implemented yet and is known tech debt.", $exprClass));
        }

        $defaultRuleset = Ruleset::default();
        $defaultResolversMap = $defaultRuleset->compile();

        $this->assertArrayHasKey(
            $exprClass,
            $defaultResolversMap,
            sprintf('Expected that expressions implemented as %s are supported but they are not.', $exprClass)
        );
    }

    public function expressions()
    {
        $baseClassReflection = new ReflectionClass(Expr::class);
        $baseNs = $baseClassReflection->getNamespaceName();
        $location = dirname($baseClassReflection->getFileName());
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($location),
            RecursiveIteratorIterator::SELF_FIRST
        );

        $expressions = [];
        foreach ($iterator as $filePath => $fileInfo) {
            $className = str_replace([$location, '.php', '/'], [$baseNs, '', '\\'], $filePath);
            try {
                $r = new ReflectionClass($className);
                if (!$r->isAbstract() && $r->isSubclassOf(Expr::class)) {
                    $expressions[$r->getName()] = [$r->getName()];
                }
            } catch (Exception $e) {
                // ignore, not a valid class declaration file
            }
        }

        return $expressions;
    }
}
