<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\CodeStructuralElement\Php\NodeVisitor;

use Closure;
use Magento\Mray\CodeStructuralElement\Php\Reflection\Context\Pointer;
use PhpParser\NodeVisitorAbstract;
use PhpParser\Node;

class NodeContextSpy extends NodeVisitorAbstract
{
    /**
     * @var Pointer
     */
    private $pointer;

    /**
     * @var Closure
     */
    private $captureContextDecision;

    /**
     * @var array
     */
    private $captured = [];

    /**
     * @param Pointer $pointer
     * @param Closure $captureContextDecision
     */
    public function __construct(Pointer $pointer, Closure $captureContextDecision)
    {
        $this->pointer = $pointer;
        $this->captureContextDecision = $captureContextDecision;
        $this->captured[] = $pointer->value();
    }

    /**
     * @return array
     */
    public function getCaptured(): array
    {
        return $this->captured;
    }

    /**
     * @param Node $node
     */
    public function leaveNode(Node $node)
    {
        if (($this->captureContextDecision)($node)) {
            $this->captured[] = $this->pointer->value();
        }
    }
}
