<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\Parse\Xml;

use Magento\Mray\CodeStructuralElement\Php\Usage\UsageCase;
use Magento\Mray\Parse\Xml\GetDbSchemaUsageCases;
use PHPUnit\Framework\TestCase;

class GetDbSchemaUsageCasesTest extends TestCase
{
    /**
     * @var GetDbSchemaUsageCases
     */
    private $service;

    protected function setUp(): void
    {
        $this->service = new GetDbSchemaUsageCases();
    }

    /**
     * @param string $path
     * @param string $version
     * @param UsageCase[] $expectedUsageCases
     * @dataProvider dbSchemaDeclarationsProvider
     */
    public function testExecute(string $path, string $version, array $expectedUsageCases): void
    {
        $content = file_get_contents($path);
        $usageCases = $this->service->execute($content, $path, $version);

        $correctedPathUsageCases = [];
        foreach ($usageCases as $usageCase) {
            $location = $usageCase->getLocation();
            $location['file'] = str_replace(__DIR__, '', $location['file']);
            $correctedPathUsageCases[$usageCase->getWhat()] = new UsageCase(
                $usageCase->getWhat(),
                $usageCase->getHow(),
                $location,
                $usageCase->getDetails()
            );
        }

        $this->assertEquals($expectedUsageCases, $correctedPathUsageCases);
    }

    /**
     * @return array[]
     */
    public function dbSchemaDeclarationsProvider(): array
    {
        return [
            [
                __DIR__ . '/_files/db_schema.xml',
                '2.4.4',
                include __DIR__ . '/_files/db_schema_declarations.php'
            ],
        ];
    }
}
