<?php
/**
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: Adobe permits you to use, modify, and distribute this file in
 * accordance with the terms of the Adobe license agreement accompanying
 * it.
 */
declare(strict_types=1);

namespace Magento\Mray\Unit\Parse\Xml;

use Magento\Mray\Parse\Xml\GetDiXmlDeclarations;
use PHPUnit\Framework\TestCase;

class GetDiXmlDeclarationsTest extends TestCase
{
    /**
     * @var GetDiXmlDeclarations
     */
    private $service;

    protected function setUp(): void
    {
        $this->service = new GetDiXmlDeclarations();
    }

    /**
     * @param string $content
     * @param array $expectedUsages
     * @dataProvider diXmlProvider
     */
    public function testExecute(string $content, array $expectedUsages): void
    {
        $usageCases = $this->service->execute($content);

        $actualResult = [];
        foreach ($usageCases as $usageCase) {
            $actualResult[] = [
                $usageCase->getWhat(),
                $usageCase->getHow(),
                $usageCase->describe()['location']['position']['startLine']
            ];
        }

        $this->assertEquals($expectedUsages, $actualResult);
    }

    /**
     * @return array[]
     */
    public function diXmlProvider(): array
    {
        return [
            [
                file_get_contents(__DIR__ . '/_files/di1.xml'),
                [
                    ['VendorIntegration\Payments\Plugin\CsrfValidatorSkip', 'plugin-type', 20],
                    ['VendorIntegration\Payments\Plugin\Cart\SetPaymentMethodOnCart', 'plugin-type', 24],
                    ['VendorIntegration\Payments\Controller\Multishipping\OverviewPost', 'preference-type', 17],
                    ['Magento\Multishipping\Controller\Checkout\OverviewPost', 'preference-for', 17],
                    ['Magento\Framework\App\Request\CsrfValidator', 'type-name', 19],
                    ['Magento\QuoteGraphQl\Model\Cart\SetPaymentMethodOnCart', 'type-name', 23],
                    ['Magento\Payment\Gateway\Validator\CountryValidator', 'virtual-type-base', 5],
                    ['Magento\Payment\Gateway\Validator\CountryValidator', 'virtual-type-base', 11],
                    ['VendorPaymentsCountryValidator', 'virtual-type-name', 5],
                    ['VendorPaymentsCountryValidator2', 'virtual-type-name', 11],
                ]
            ],
        ];
    }
}
